<?php
defined('PF_VERSION') OR exit('Access denied');
add_toolbar_button(form_button("<i class='glyphicon glyphicon-plus'></i> " . __("New User", "user"), array('onclick' => "window.location = '" . $_SERVER["REQUEST_URI"] . "&act=create'", 'class' => 'btn btn-primary')));
if(!empty($_SESSION['success'])){
    echo "<script>notif('".$_SESSION['success']."')</script>";
    unset($_SESSION['success']);
}
?>
<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title"><i class="fa fa-list"></i> <?php echo __("User", "user"); ?></h3>
    </div>
    <div class="panel-body">
        <div class="row">
            <div class="col-md-8">
                <div class="btn-group pull-left btnGroupBulkAction" id="action-box">
                    <button type="button" class="btn btn-default btn-md btn-flat dropdown-toggle" data-toggle="dropdown">
                        <?php echo __("Select Action", "user"); ?> <span class="caret"></span>
                    </button>
                    <ul class="dropdown-menu" role="menu" id="bulkAction">
                        <li><a href="#" onclick="confirmaction('del')"><?php echo __('Delete', 'user'); ?></a></li>
                        <li><a href="#" onclick="confirmaction('active')"><?php echo __('Active', 'user'); ?></a></li>
                        <li><a href="#" onclick="confirmaction('deactive')"><?php echo __('Deactive', 'user'); ?></a></li>
                    </ul>
                </div>
            </div>
            <div class="col-md-4 search-form">
                <form name="search" method="get" action="" class="form-inline">
                    <div class="input-group">
                        <input type="hidden" name="admin-page" value="users" />
                        <input type="text" class="form-control" name="username" value='<?php echo isset($_GET['username']) ? $_GET['username'] : ''; ?>' placeholder="<?php echo __('Search by username', 'user'); ?>">
                        <span class="input-group-btn">
                            <button class="btn btn-default btn-flat" type="submit" id="btnSearch">
                                <i class="fa fa-search"></i> <?php echo __('Search', 'user') ?>
                            </button>
                            <a href="<?php echo admin_url(array('admin-page' => 'users'), false); ?>" class="btn btn-default btn-flat"> 
                                <i class="fa fa-times-circle"></i>
                            </a>

                            <a href="#" data-toggle="modal" data-target="#myModal" class="btn btn-default btn-flat">
                                <i class="fa fa-search-plus"></i>
                            </a>
                        </span>
                    </div>
                </form>
            </div>

        </div>
        <div class="row medium-action padding10-0">
            <div class="col-md-6"> 
                <div class="btn-group">
                    <button type="button" class="btn btn-default btn-sm btn-flat dropdown-toggle" data-toggle="dropdown">
                        <?php
                        if (empty($_GET['active'])) {
                            echo __('All', 'user');
                        } elseif ($_GET['active'] == 1) {
                            echo __('Activated', 'user');
                        } elseif ($_GET['active'] == 2) {
                            echo __('Deactivated', 'user');
                        }
                        ?>
                        <span class="caret"></span>
                    </button>
                    <ul class="dropdown-menu" role="menu">
                        <li><a href="<?php echo admin_url("admin-page=users", false); ?>"> <?php echo __('All', 'user'); ?></a></li>
                        <li><a href="<?php echo admin_url("admin-page=users&active=1", false); ?>"> <?php echo __('Activated', 'user'); ?></a></li>
                        <li><a href="<?php echo admin_url("admin-page=users&active=2", false); ?>"> <?php echo __('Deactivated', 'user'); ?></a></li>
                    </ul>
                </div>
            </div>
            <div class="col-md-6">
                <div class="pull-right">
<?php echo $pages->short_page_link(); ?>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
        <form method=post action='' id='checkform'>
            <input type="hidden" id='action' name="action" />
            <div class="table-responsive">
                <table class='bootstrap-table' id='listcheck'>
                    <thead>
                        <tr>
                            <th data-fixed="left" class='width40'><input type='checkbox' id='checkall' name='checkall' /> </th>
                            <th class='width200'><?php echo __("Username", "user"); ?></th>
                            <th class='width200'><?php echo __("Display Name", "user"); ?></th>
                            <th class='width200'><?php echo __("Email", "user"); ?></th>
                            <th class='width100'><?php echo __("Role", "user"); ?></th>
                            <th class='width80'><?php echo __("Activation", "user"); ?></th>
                            <th data-fixed="right" class='width150'><?php echo __("Actions", "user"); ?></th>
                        </tr>
                    </thead>
                    <tbody>
<?php if(!empty($list)) {foreach ($list as $row) { ?>
                            <tr><td> <input type='checkbox' name='cid[]' value=' <?php echo $row['uid']; ?> ' class='checkbox' /></td>
                                <td><?php echo htmlspecialchars($row['user_name']); ?></td>
                                <td><?php echo htmlspecialchars($row['user_displayname']); ?></td>
                                <td><?php echo htmlspecialchars($row['user_email']); ?></td>
                                <td><?php echo $user_role[$row['user_role']]; ?></td>
                                <td><?php
                                switch ($row['user_activation']) {
                                        case '1':
                                            echo "<a href='" . admin_url("admin-page=users&do=deactive&id=" . $row['uid']) . "' class='label label-success'>" . __("Activated", 'user') . "</a>";
                                            break;
                                        default:
                                            echo "<a href='" . admin_url("admin-page=users&do=active&id=" . $row['uid']) . "' class='label label-danger'>" . __("Deactivated", 'user') . "</a>";
                                            break;
                                        }
                                ?></td>
                                <td><a class='btn btn-info btn-xs' href='<?php echo $_SERVER['REQUEST_URI'] . "&act=edit&id=" . $row['uid'] ?>'><i class='fa fa-pencil-square-o'></i> <?php echo __("Edit", "user") ?></span></a>
                                    <a class='btn btn-danger btn-xs' onclick="delete_user('<?php echo admin_url('action=delete&id=' . $row['uid']); ?>');
                                  return;">
                                        <i class='fa fa-times-circle'></i> <?php echo __('Delete', 'user'); ?>   </a> </td></tr>
<?php } }?>
                    </tbody></table></div>
        </form>
        </div>
    </div>
        <div id="myModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
            <div class="modal-dialog">
                <div class="modal-content">

                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                        <h4 class="modal-title" id="myModalLabel"><?php echo __("Advance Search", "user"); ?></h4>
                    </div>
                    <form name="adsearch" method="get" action='' class='form-horizontal' >
                        <input type="hidden" name='admin-page' value="users" />
                        <div class="modal-body">
                            <div class="form-group">
                                <label class="col-sm-4 control-label" ><?php echo __("Username", "user"); ?></label>
                                <div class="col-sm-8">
                                    <input type="text" class="form-control" name='username' id="username" value="<?php
                                    if (isset($_GET['username'])) {
                                        echo $_GET['username'];
                                    }
?>" />
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="col-sm-4 control-label" ><?php echo __("Email", "user"); ?></label>
                                <div class="col-sm-8">
                                    <input type="text" class="form-control" name='email' id="email" value="<?php
                                    if (isset($_GET['email'])) {
                                        echo $_GET['email'];
                                    }
?>"/>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="col-sm-4 control-label" ><?php echo __("Role", "user"); ?></label>
                                <div class="col-sm-8">
                                    <select class="form-control" name="role">
                                        <option value=""><?php echo __("Unknown", "user"); ?></option>
                                        <?php
                                        for ($i = 1; $i <= count($user_role); $i++) {
                                            $rolename = $user_role[$i];
                                            $selected = "";
                                            if (!empty($_GET['role']) && $_GET['role'] == $i) {
                                                $selected = "selected";
                                            }
                                            echo "<option value='$i' $selected>$rolename</option>";
                                        }
                                        ?>                      
                                    </select>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="col-sm-4 control-label" ><?php echo __("Activation", "user"); ?></label>
                                <div class="col-sm-8">
                                    <select class="form-control" name="active">
                                        <option value="0" ><?php echo __("Unknown", "user"); ?></option>
                                        <option value="1" <?php
                                        if (isset($_GET['active']) && $_GET['active'] == 1) {
                                            echo "selected";
                                        }
                                        ?> ><?php echo __("Yes", "user"); ?></option>
                                        <option value="2" <?php
                                        if (isset($_GET['active']) && $_GET['active'] == 2) {
                                            echo "selected";
                                        }
                                        ?>><?php echo __("No", "user"); ?></option>                    
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo __("Close", "user"); ?></button>
                            <button type="submit" name="submit"  class="btn btn-primary"><?php echo __("Show Result", "user"); ?></button>
                        </div>
                    </form>    
                </div><!-- /.modal-content -->
            </div>
        </div>
    </div>
    <div class="panel-footer">
        <div class="row">
            <div class="col-sm-6">
<?php echo $pages->page_lable(); ?>
            </div>
            <div class="col-sm-6">
                <!-- Pagination -->
<?php echo $pages->page_links($org_url . '&'); ?>
                <!-- Pagination -->
            </div>
        </div>
    </div>
</div>
<script>
    function delete_user(url) {
        $.sModal({
            image: '<?php echo RELATIVE_PATH; ?>/admin/plugins/theme/layouts/images/confirm.png',
            content: '<?php echo __('Are you sure to delete this item?', 'user'); ?>',
            animate: 'fadeDown',
            buttons: [
                {
                    text: '<i class="fa fa-times-circle"></i> <?php echo __('Delete', 'user'); ?> ',
                    addClass: 'btn-danger',
                    click: function(id, data) {
                        window.location = url;
                        $.sModal('close', id);
                    }
                },
                {
                    text: ' <?php echo __('Cancel', 'user'); ?> ',
                    click: function(id, data) {
                        $.sModal('close', id);
                    }
                },
            ]
        });
    }
    function confirmaction(act) {
        $.sModal({
            image: '<?php echo RELATIVE_PATH; ?>/admin/plugins/theme/layouts/images/confirm.png',
            content: '<?php echo __('Are you sure with this action?', 'user'); ?>',
            animate: 'fadeDown',
            buttons: [
                {
                    text: '<i class="fa fa-times-circle"></i> <?php echo __('Confirm', 'user'); ?> ',
                    addClass: 'btn-danger',
                    click: function(id, data) {
                        $('#action').val(act);
                        $('#checkform').submit();
                        $.sModal('close', id);
                    }
                },
                {
                    text: ' <?php echo __('Cancel', 'user'); ?> ',
                    click: function(id, data) {
                        $.sModal('close', id);
                    }
                },
            ]
        });
    }
</script>